@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetClusterAgentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusterAgents.
 * @property project The ID or full path of the project owned by the authenticated user.
 */
public data class GetClusterAgentsPlainArgs(
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetClusterAgentsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetClusterAgentsPlainArgs =
        com.pulumi.gitlab.inputs.GetClusterAgentsPlainArgs.builder()
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterAgentsPlainArgs].
 */
@PulumiTagMarker
public class GetClusterAgentsPlainArgsBuilder internal constructor() {
    private var project: String? = null

    /**
     * @param value The ID or full path of the project owned by the authenticated user.
     */
    @JvmName("qiaxpysfpffcqljh")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetClusterAgentsPlainArgs = GetClusterAgentsPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
