@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetComplianceFrameworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getComplianceFramework.
 * @property name Name for the compliance framework.
 * @property namespacePath Full path of the namespace to where the compliance framework is.
 */
public data class GetComplianceFrameworkPlainArgs(
    public val name: String,
    public val namespacePath: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetComplianceFrameworkPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetComplianceFrameworkPlainArgs =
        com.pulumi.gitlab.inputs.GetComplianceFrameworkPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .namespacePath(namespacePath.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetComplianceFrameworkPlainArgs].
 */
@PulumiTagMarker
public class GetComplianceFrameworkPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var namespacePath: String? = null

    /**
     * @param value Name for the compliance framework.
     */
    @JvmName("ciceacvnsiflfijd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Full path of the namespace to where the compliance framework is.
     */
    @JvmName("qxcjcekxxlyjmgbb")
    public suspend fun namespacePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespacePath = mapped
    }

    internal fun build(): GetComplianceFrameworkPlainArgs = GetComplianceFrameworkPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        namespacePath = namespacePath ?: throw PulumiNullFieldException("namespacePath"),
    )
}
