@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupHookPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupHook.
 * @property group The ID or full path of the group.
 * @property hookId The id of the group hook.
 */
public data class GetGroupHookPlainArgs(
    public val group: String,
    public val hookId: Int,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupHookPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupHookPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupHookPlainArgs.builder()
            .group(group.let({ args0 -> args0 }))
            .hookId(hookId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupHookPlainArgs].
 */
@PulumiTagMarker
public class GetGroupHookPlainArgsBuilder internal constructor() {
    private var group: String? = null

    private var hookId: Int? = null

    /**
     * @param value The ID or full path of the group.
     */
    @JvmName("opclrqwffbsoxtcq")
    public suspend fun group(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.group = mapped
    }

    /**
     * @param value The id of the group hook.
     */
    @JvmName("yimpsxfnrymrkhuq")
    public suspend fun hookId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hookId = mapped
    }

    internal fun build(): GetGroupHookPlainArgs = GetGroupHookPlainArgs(
        group = group ?: throw PulumiNullFieldException("group"),
        hookId = hookId ?: throw PulumiNullFieldException("hookId"),
    )
}
