@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupHooksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupHooks.
 * @property group The ID or full path of the group.
 */
public data class GetGroupHooksPlainArgs(
    public val group: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupHooksPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupHooksPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupHooksPlainArgs.builder()
            .group(group.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupHooksPlainArgs].
 */
@PulumiTagMarker
public class GetGroupHooksPlainArgsBuilder internal constructor() {
    private var group: String? = null

    /**
     * @param value The ID or full path of the group.
     */
    @JvmName("eycgtjasbhkktpwx")
    public suspend fun group(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.group = mapped
    }

    internal fun build(): GetGroupHooksPlainArgs = GetGroupHooksPlainArgs(
        group = group ?: throw PulumiNullFieldException("group"),
    )
}
