@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupIds.
 * @property group The ID or URL-encoded path of the group.
 */
public data class GetGroupIdsPlainArgs(
    public val group: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupIdsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupIdsPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupIdsPlainArgs.builder()
            .group(group.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupIdsPlainArgs].
 */
@PulumiTagMarker
public class GetGroupIdsPlainArgsBuilder internal constructor() {
    private var group: String? = null

    /**
     * @param value The ID or URL-encoded path of the group.
     */
    @JvmName("ormpdukmgadcblgq")
    public suspend fun group(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.group = mapped
    }

    internal fun build(): GetGroupIdsPlainArgs = GetGroupIdsPlainArgs(
        group = group ?: throw PulumiNullFieldException("group"),
    )
}
