@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupMembershipPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupMembership.
 * @property accessLevel Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
 * @property fullPath The full path of the group.
 * @property groupId The ID of the group.
 * @property inherited Return all project members including members through ancestor groups.
 */
public data class GetGroupMembershipPlainArgs(
    public val accessLevel: String? = null,
    public val fullPath: String? = null,
    public val groupId: Int? = null,
    public val inherited: Boolean? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupMembershipPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupMembershipPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupMembershipPlainArgs.builder()
            .accessLevel(accessLevel?.let({ args0 -> args0 }))
            .fullPath(fullPath?.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .inherited(inherited?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupMembershipPlainArgs].
 */
@PulumiTagMarker
public class GetGroupMembershipPlainArgsBuilder internal constructor() {
    private var accessLevel: String? = null

    private var fullPath: String? = null

    private var groupId: Int? = null

    private var inherited: Boolean? = null

    /**
     * @param value Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     */
    @JvmName("bxxmgvbbiegtsuke")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessLevel = mapped
    }

    /**
     * @param value The full path of the group.
     */
    @JvmName("ggkaebjqwmfgappr")
    public suspend fun fullPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fullPath = mapped
    }

    /**
     * @param value The ID of the group.
     */
    @JvmName("punrhutwedceyday")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value Return all project members including members through ancestor groups.
     */
    @JvmName("esjgiwondcbnovhk")
    public suspend fun inherited(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.inherited = mapped
    }

    internal fun build(): GetGroupMembershipPlainArgs = GetGroupMembershipPlainArgs(
        accessLevel = accessLevel,
        fullPath = fullPath,
        groupId = groupId,
        inherited = inherited,
    )
}
