@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroup.
 * @property fullPath The full path of the group.
 * @property groupId The ID of the group.
 */
public data class GetGroupPlainArgs(
    public val fullPath: String? = null,
    public val groupId: Int? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupPlainArgs.builder()
            .fullPath(fullPath?.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetGroupPlainArgsBuilder internal constructor() {
    private var fullPath: String? = null

    private var groupId: Int? = null

    /**
     * @param value The full path of the group.
     */
    @JvmName("vyhmhxxflblfrjmx")
    public suspend fun fullPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fullPath = mapped
    }

    /**
     * @param value The ID of the group.
     */
    @JvmName("clltpmbocowrpywe")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    internal fun build(): GetGroupPlainArgs = GetGroupPlainArgs(
        fullPath = fullPath,
        groupId = groupId,
    )
}
