@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupVariablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupVariable.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
 * @property group The name or id of the group.
 * @property key The name of the variable.
 */
public data class GetGroupVariablePlainArgs(
    public val environmentScope: String? = null,
    public val group: String,
    public val key: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupVariablePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupVariablePlainArgs =
        com.pulumi.gitlab.inputs.GetGroupVariablePlainArgs.builder()
            .environmentScope(environmentScope?.let({ args0 -> args0 }))
            .group(group.let({ args0 -> args0 }))
            .key(key.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupVariablePlainArgs].
 */
@PulumiTagMarker
public class GetGroupVariablePlainArgsBuilder internal constructor() {
    private var environmentScope: String? = null

    private var group: String? = null

    private var key: String? = null

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    @JvmName("hpoqlcmigrdyoogu")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.environmentScope = mapped
    }

    /**
     * @param value The name or id of the group.
     */
    @JvmName("rkhphssuijskdynk")
    public suspend fun group(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.group = mapped
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("etpmowpodbhqlogu")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    internal fun build(): GetGroupVariablePlainArgs = GetGroupVariablePlainArgs(
        environmentScope = environmentScope,
        group = group ?: throw PulumiNullFieldException("group"),
        key = key ?: throw PulumiNullFieldException("key"),
    )
}
