@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupVariablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupVariables.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`).
 * @property group The name or id of the group.
 */
public data class GetGroupVariablesPlainArgs(
    public val environmentScope: String? = null,
    public val group: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupVariablesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupVariablesPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupVariablesPlainArgs.builder()
            .environmentScope(environmentScope?.let({ args0 -> args0 }))
            .group(group.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupVariablesPlainArgs].
 */
@PulumiTagMarker
public class GetGroupVariablesPlainArgsBuilder internal constructor() {
    private var environmentScope: String? = null

    private var group: String? = null

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`).
     */
    @JvmName("lwjwgyiewbdmdlhd")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.environmentScope = mapped
    }

    /**
     * @param value The name or id of the group.
     */
    @JvmName("ndbhcsrmvxbfyefa")
    public suspend fun group(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.group = mapped
    }

    internal fun build(): GetGroupVariablesPlainArgs = GetGroupVariablesPlainArgs(
        environmentScope = environmentScope,
        group = group ?: throw PulumiNullFieldException("group"),
    )
}
