@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroups.
 * @property orderBy Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
 * @property search Search groups by name or path.
 * @property sort Sort groups' list in asc or desc order. (Requires administrator privileges)
 * @property topLevelOnly Limit to top level groups, excluding all subgroups.
 */
public data class GetGroupsPlainArgs(
    public val orderBy: String? = null,
    public val search: String? = null,
    public val sort: String? = null,
    public val topLevelOnly: Boolean? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetGroupsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetGroupsPlainArgs =
        com.pulumi.gitlab.inputs.GetGroupsPlainArgs.builder()
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .sort(sort?.let({ args0 -> args0 }))
            .topLevelOnly(topLevelOnly?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetGroupsPlainArgsBuilder internal constructor() {
    private var orderBy: String? = null

    private var search: String? = null

    private var sort: String? = null

    private var topLevelOnly: Boolean? = null

    /**
     * @param value Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
     */
    @JvmName("rtjcfrfppocxmrio")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value Search groups by name or path.
     */
    @JvmName("yivxvojwwrcjqeef")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value Sort groups' list in asc or desc order. (Requires administrator privileges)
     */
    @JvmName("hneaagmjrdcuremg")
    public suspend fun sort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sort = mapped
    }

    /**
     * @param value Limit to top level groups, excluding all subgroups.
     */
    @JvmName("tifgwtvwjdmyqxmi")
    public suspend fun topLevelOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.topLevelOnly = mapped
    }

    internal fun build(): GetGroupsPlainArgs = GetGroupsPlainArgs(
        orderBy = orderBy,
        search = search,
        sort = sort,
        topLevelOnly = topLevelOnly,
    )
}
