@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetInstanceDeployKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceDeployKeys.
 * @property public Only return deploy keys that are public.
 */
public data class GetInstanceDeployKeysPlainArgs(
    public val `public`: Boolean? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetInstanceDeployKeysPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetInstanceDeployKeysPlainArgs =
        com.pulumi.gitlab.inputs.GetInstanceDeployKeysPlainArgs.builder()
            .public_(`public`?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceDeployKeysPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceDeployKeysPlainArgsBuilder internal constructor() {
    private var `public`: Boolean? = null

    /**
     * @param value Only return deploy keys that are public.
     */
    @JvmName("vjtminilvwmkfgyw")
    public suspend fun `public`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`public` = mapped
    }

    internal fun build(): GetInstanceDeployKeysPlainArgs = GetInstanceDeployKeysPlainArgs(
        `public` = `public`,
    )
}
