@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetInstanceVariablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceVariable.
 * @property key The name of the variable.
 */
public data class GetInstanceVariablePlainArgs(
    public val key: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetInstanceVariablePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetInstanceVariablePlainArgs =
        com.pulumi.gitlab.inputs.GetInstanceVariablePlainArgs.builder()
            .key(key.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceVariablePlainArgs].
 */
@PulumiTagMarker
public class GetInstanceVariablePlainArgsBuilder internal constructor() {
    private var key: String? = null

    /**
     * @param value The name of the variable.
     */
    @JvmName("qocuwlgusecntwlo")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    internal fun build(): GetInstanceVariablePlainArgs = GetInstanceVariablePlainArgs(
        key = key ?: throw PulumiNullFieldException("key"),
    )
}
