@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetPipelineSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPipelineSchedule.
 * @property cronTimezone The timezone.
 * @property pipelineScheduleId The pipeline schedule id.
 * @property project The name or id of the project to add the schedule to.
 */
public data class GetPipelineSchedulePlainArgs(
    public val cronTimezone: String? = null,
    public val pipelineScheduleId: Int,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetPipelineSchedulePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetPipelineSchedulePlainArgs =
        com.pulumi.gitlab.inputs.GetPipelineSchedulePlainArgs.builder()
            .cronTimezone(cronTimezone?.let({ args0 -> args0 }))
            .pipelineScheduleId(pipelineScheduleId.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetPipelineSchedulePlainArgsBuilder internal constructor() {
    private var cronTimezone: String? = null

    private var pipelineScheduleId: Int? = null

    private var project: String? = null

    /**
     * @param value The timezone.
     */
    @JvmName("pqaqmebpswlpctob")
    public suspend fun cronTimezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cronTimezone = mapped
    }

    /**
     * @param value The pipeline schedule id.
     */
    @JvmName("tgnkiretlamvhuig")
    public suspend fun pipelineScheduleId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineScheduleId = mapped
    }

    /**
     * @param value The name or id of the project to add the schedule to.
     */
    @JvmName("rtqqwsdrcwywyqck")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetPipelineSchedulePlainArgs = GetPipelineSchedulePlainArgs(
        cronTimezone = cronTimezone,
        pipelineScheduleId = pipelineScheduleId ?: throw PulumiNullFieldException("pipelineScheduleId"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
