@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetPipelineSchedulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPipelineSchedules.
 * @property project The name or id of the project to add the schedule to.
 */
public data class GetPipelineSchedulesPlainArgs(
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetPipelineSchedulesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetPipelineSchedulesPlainArgs =
        com.pulumi.gitlab.inputs.GetPipelineSchedulesPlainArgs.builder()
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineSchedulesPlainArgs].
 */
@PulumiTagMarker
public class GetPipelineSchedulesPlainArgsBuilder internal constructor() {
    private var project: String? = null

    /**
     * @param value The name or id of the project to add the schedule to.
     */
    @JvmName("fkyvmpprvtjdqges")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetPipelineSchedulesPlainArgs = GetPipelineSchedulesPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
