@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectBranchesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectBranches.
 * @property project ID or URL-encoded path of the project owned by the authenticated user.
 */
public data class GetProjectBranchesPlainArgs(
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectBranchesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectBranchesPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectBranchesPlainArgs.builder()
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectBranchesPlainArgs].
 */
@PulumiTagMarker
public class GetProjectBranchesPlainArgsBuilder internal constructor() {
    private var project: String? = null

    /**
     * @param value ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("wfpisejcifhftbqv")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectBranchesPlainArgs = GetProjectBranchesPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
