@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectHookPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectHook.
 * @property hookId The id of the project hook.
 * @property project The name or id of the project to add the hook to.
 */
public data class GetProjectHookPlainArgs(
    public val hookId: Int,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectHookPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectHookPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectHookPlainArgs.builder()
            .hookId(hookId.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectHookPlainArgs].
 */
@PulumiTagMarker
public class GetProjectHookPlainArgsBuilder internal constructor() {
    private var hookId: Int? = null

    private var project: String? = null

    /**
     * @param value The id of the project hook.
     */
    @JvmName("evpgryymgpaqmwjm")
    public suspend fun hookId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hookId = mapped
    }

    /**
     * @param value The name or id of the project to add the hook to.
     */
    @JvmName("jvhujfjlljxtoint")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectHookPlainArgs = GetProjectHookPlainArgs(
        hookId = hookId ?: throw PulumiNullFieldException("hookId"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
