@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectHooksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectHooks.
 * @property project The name or id of the project.
 */
public data class GetProjectHooksPlainArgs(
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectHooksPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectHooksPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectHooksPlainArgs.builder()
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectHooksPlainArgs].
 */
@PulumiTagMarker
public class GetProjectHooksPlainArgsBuilder internal constructor() {
    private var project: String? = null

    /**
     * @param value The name or id of the project.
     */
    @JvmName("ciqyrqkfujppasor")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectHooksPlainArgs = GetProjectHooksPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
