@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectIds.
 * @property project The ID or URL-encoded path of the project.
 */
public data class GetProjectIdsPlainArgs(
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectIdsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectIdsPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectIdsPlainArgs.builder()
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectIdsPlainArgs].
 */
@PulumiTagMarker
public class GetProjectIdsPlainArgsBuilder internal constructor() {
    private var project: String? = null

    /**
     * @param value The ID or URL-encoded path of the project.
     */
    @JvmName("myrkekjrpbrgpaqf")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectIdsPlainArgs = GetProjectIdsPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
