@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectIssuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectIssue.
 * @property iid The internal ID of the project's issue.
 * @property project The name or ID of the project.
 */
public data class GetProjectIssuePlainArgs(
    public val iid: Int,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectIssuePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectIssuePlainArgs =
        com.pulumi.gitlab.inputs.GetProjectIssuePlainArgs.builder()
            .iid(iid.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectIssuePlainArgs].
 */
@PulumiTagMarker
public class GetProjectIssuePlainArgsBuilder internal constructor() {
    private var iid: Int? = null

    private var project: String? = null

    /**
     * @param value The internal ID of the project's issue.
     */
    @JvmName("rcnlauplmgajjygm")
    public suspend fun iid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iid = mapped
    }

    /**
     * @param value The name or ID of the project.
     */
    @JvmName("wafppbmouilsenij")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectIssuePlainArgs = GetProjectIssuePlainArgs(
        iid = iid ?: throw PulumiNullFieldException("iid"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
