@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectIssuesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectIssues.
 * @property assigneeId Return issues assigned to the given user id. Mutually exclusive with assignee_username. None returns unassigned issues. Any returns issues with an assignee.
 * @property assigneeUsername Return issues assigned to the given username. Similar to assignee*id and mutually exclusive with assignee*id. In GitLab CE, the assignee_username array should only contain a single value. Otherwise, an invalid parameter error is returned.
 * @property authorId Return issues created by the given user id. Combine with scope=all or scope=assigned*to*me.
 * @property confidential Filter confidential or public issues.
 * @property createdAfter Return issues created on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property createdBefore Return issues created on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property dueDate Return issues that have no due date, are overdue, or whose due date is this week, this month, or between two weeks ago and next month. Accepts: 0 (no due date), any, today, tomorrow, overdue, week, month, next*month*and*previous*two_weeks.
 * @property iids Return only the issues having the given iid
 * @property issueType Filter to a given type of issue. Valid values are [issue incident test_case]. (Introduced in GitLab 13.12)
 * @property labels Return issues with labels. Issues must have all labels to be returned. None lists all issues with no labels. Any lists all issues with at least one label. No+Label (Deprecated) lists all issues with no labels. Predefined names are case-insensitive.
 * @property milestone The milestone title. None lists all issues with no milestone. Any lists all issues that have an assigned milestone.
 * @property myReactionEmoji Return issues reacted by the authenticated user by the given emoji. None returns issues not given a reaction. Any returns issues given at least one reaction.
 * @property notAssigneeIds Return issues that do not match the assignee id.
 * @property notAuthorIds Return issues that do not match the author id.
 * @property notLabels Return issues that do not match the labels.
 * @property notMilestone Return issues that do not match the milestone.
 * @property notMyReactionEmojis Return issues not reacted by the authenticated user by the given emoji.
 * @property orderBy Return issues ordered by. Valid values are `created_at`, `updated_at`, `priority`, `due_date`, `relative_position`, `label_priority`, `milestone_due`, `popularity`, `weight`. Default is created_at
 * @property project The name or id of the project.
 * @property scope Return issues for the given scope. Valid values are `created_by_me`, `assigned_to_me`, `all`. Defaults to all.
 * @property search Search project issues against their title and description
 * @property sort Return issues sorted in asc or desc order. Default is desc
 * @property updatedAfter Return issues updated on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property updatedBefore Return issues updated on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property weight Return issues with the specified weight. None returns issues with no weight assigned. Any returns issues with a weight assigned.
 * @property withLabelsDetails If true, the response returns more details for each label in labels field: :name, :color, :description, :description*html, :text*color. Default is false. description_html was introduced in GitLab 12.7
 */
public data class GetProjectIssuesPlainArgs(
    public val assigneeId: Int? = null,
    public val assigneeUsername: String? = null,
    public val authorId: Int? = null,
    public val confidential: Boolean? = null,
    public val createdAfter: String? = null,
    public val createdBefore: String? = null,
    public val dueDate: String? = null,
    public val iids: List<Int>? = null,
    public val issueType: String? = null,
    public val labels: List<String>? = null,
    public val milestone: String? = null,
    public val myReactionEmoji: String? = null,
    public val notAssigneeIds: List<Int>? = null,
    public val notAuthorIds: List<Int>? = null,
    public val notLabels: List<String>? = null,
    public val notMilestone: String? = null,
    public val notMyReactionEmojis: List<String>? = null,
    public val orderBy: String? = null,
    public val project: String,
    public val scope: String? = null,
    public val search: String? = null,
    public val sort: String? = null,
    public val updatedAfter: String? = null,
    public val updatedBefore: String? = null,
    public val weight: Int? = null,
    public val withLabelsDetails: Boolean? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectIssuesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectIssuesPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectIssuesPlainArgs.builder()
            .assigneeId(assigneeId?.let({ args0 -> args0 }))
            .assigneeUsername(assigneeUsername?.let({ args0 -> args0 }))
            .authorId(authorId?.let({ args0 -> args0 }))
            .confidential(confidential?.let({ args0 -> args0 }))
            .createdAfter(createdAfter?.let({ args0 -> args0 }))
            .createdBefore(createdBefore?.let({ args0 -> args0 }))
            .dueDate(dueDate?.let({ args0 -> args0 }))
            .iids(iids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .issueType(issueType?.let({ args0 -> args0 }))
            .labels(labels?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .milestone(milestone?.let({ args0 -> args0 }))
            .myReactionEmoji(myReactionEmoji?.let({ args0 -> args0 }))
            .notAssigneeIds(notAssigneeIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .notAuthorIds(notAuthorIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .notLabels(notLabels?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .notMilestone(notMilestone?.let({ args0 -> args0 }))
            .notMyReactionEmojis(notMyReactionEmojis?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 }))
            .scope(scope?.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .sort(sort?.let({ args0 -> args0 }))
            .updatedAfter(updatedAfter?.let({ args0 -> args0 }))
            .updatedBefore(updatedBefore?.let({ args0 -> args0 }))
            .weight(weight?.let({ args0 -> args0 }))
            .withLabelsDetails(withLabelsDetails?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectIssuesPlainArgs].
 */
@PulumiTagMarker
public class GetProjectIssuesPlainArgsBuilder internal constructor() {
    private var assigneeId: Int? = null

    private var assigneeUsername: String? = null

    private var authorId: Int? = null

    private var confidential: Boolean? = null

    private var createdAfter: String? = null

    private var createdBefore: String? = null

    private var dueDate: String? = null

    private var iids: List<Int>? = null

    private var issueType: String? = null

    private var labels: List<String>? = null

    private var milestone: String? = null

    private var myReactionEmoji: String? = null

    private var notAssigneeIds: List<Int>? = null

    private var notAuthorIds: List<Int>? = null

    private var notLabels: List<String>? = null

    private var notMilestone: String? = null

    private var notMyReactionEmojis: List<String>? = null

    private var orderBy: String? = null

    private var project: String? = null

    private var scope: String? = null

    private var search: String? = null

    private var sort: String? = null

    private var updatedAfter: String? = null

    private var updatedBefore: String? = null

    private var weight: Int? = null

    private var withLabelsDetails: Boolean? = null

    /**
     * @param value Return issues assigned to the given user id. Mutually exclusive with assignee_username. None returns unassigned issues. Any returns issues with an assignee.
     */
    @JvmName("japuyuywwsyydhcj")
    public suspend fun assigneeId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.assigneeId = mapped
    }

    /**
     * @param value Return issues assigned to the given username. Similar to assignee*id and mutually exclusive with assignee*id. In GitLab CE, the assignee_username array should only contain a single value. Otherwise, an invalid parameter error is returned.
     */
    @JvmName("ngneynlkbmubqnks")
    public suspend fun assigneeUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.assigneeUsername = mapped
    }

    /**
     * @param value Return issues created by the given user id. Combine with scope=all or scope=assigned*to*me.
     */
    @JvmName("oprrknauthtpbvtk")
    public suspend fun authorId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.authorId = mapped
    }

    /**
     * @param value Filter confidential or public issues.
     */
    @JvmName("yfvriocnbbmrudde")
    public suspend fun confidential(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.confidential = mapped
    }

    /**
     * @param value Return issues created on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     */
    @JvmName("xmnuwwsyiobqfvqp")
    public suspend fun createdAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createdAfter = mapped
    }

    /**
     * @param value Return issues created on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     */
    @JvmName("lhagxnusxlcidqvp")
    public suspend fun createdBefore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createdBefore = mapped
    }

    /**
     * @param value Return issues that have no due date, are overdue, or whose due date is this week, this month, or between two weeks ago and next month. Accepts: 0 (no due date), any, today, tomorrow, overdue, week, month, next*month*and*previous*two_weeks.
     */
    @JvmName("fftlsbnfkwttttdu")
    public suspend fun dueDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dueDate = mapped
    }

    /**
     * @param value Return only the issues having the given iid
     */
    @JvmName("dbrpffuhlgssmswe")
    public suspend fun iids(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.iids = mapped
    }

    /**
     * @param values Return only the issues having the given iid
     */
    @JvmName("mvsxittwfynymcis")
    public suspend fun iids(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iids = mapped
    }

    /**
     * @param value Filter to a given type of issue. Valid values are [issue incident test_case]. (Introduced in GitLab 13.12)
     */
    @JvmName("bqvkolwlimodekfj")
    public suspend fun issueType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.issueType = mapped
    }

    /**
     * @param value Return issues with labels. Issues must have all labels to be returned. None lists all issues with no labels. Any lists all issues with at least one label. No+Label (Deprecated) lists all issues with no labels. Predefined names are case-insensitive.
     */
    @JvmName("ffvinxfgvahyymcr")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.labels = mapped
    }

    /**
     * @param values Return issues with labels. Issues must have all labels to be returned. None lists all issues with no labels. Any lists all issues with at least one label. No+Label (Deprecated) lists all issues with no labels. Predefined names are case-insensitive.
     */
    @JvmName("iwsluiytoqsjdcbb")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labels = mapped
    }

    /**
     * @param value The milestone title. None lists all issues with no milestone. Any lists all issues that have an assigned milestone.
     */
    @JvmName("nsujedqvhsnoheoc")
    public suspend fun milestone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.milestone = mapped
    }

    /**
     * @param value Return issues reacted by the authenticated user by the given emoji. None returns issues not given a reaction. Any returns issues given at least one reaction.
     */
    @JvmName("jtpcnpkevbpsbrjb")
    public suspend fun myReactionEmoji(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.myReactionEmoji = mapped
    }

    /**
     * @param value Return issues that do not match the assignee id.
     */
    @JvmName("ygvdnshyeorywuyb")
    public suspend fun notAssigneeIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAssigneeIds = mapped
    }

    /**
     * @param values Return issues that do not match the assignee id.
     */
    @JvmName("uyffmidsnmhwwplb")
    public suspend fun notAssigneeIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notAssigneeIds = mapped
    }

    /**
     * @param value Return issues that do not match the author id.
     */
    @JvmName("svagydoceeuqkyjw")
    public suspend fun notAuthorIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAuthorIds = mapped
    }

    /**
     * @param values Return issues that do not match the author id.
     */
    @JvmName("aeftswwrapkjtdoo")
    public suspend fun notAuthorIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notAuthorIds = mapped
    }

    /**
     * @param value Return issues that do not match the labels.
     */
    @JvmName("usjuqxpldqnvdgsg")
    public suspend fun notLabels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notLabels = mapped
    }

    /**
     * @param values Return issues that do not match the labels.
     */
    @JvmName("uobyvppiqgwpxtkb")
    public suspend fun notLabels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notLabels = mapped
    }

    /**
     * @param value Return issues that do not match the milestone.
     */
    @JvmName("bftsxsqtfhuoqdrs")
    public suspend fun notMilestone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notMilestone = mapped
    }

    /**
     * @param value Return issues not reacted by the authenticated user by the given emoji.
     */
    @JvmName("mhpqdbkormnvwfhq")
    public suspend fun notMyReactionEmojis(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notMyReactionEmojis = mapped
    }

    /**
     * @param values Return issues not reacted by the authenticated user by the given emoji.
     */
    @JvmName("hqwmejwktjuexfar")
    public suspend fun notMyReactionEmojis(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notMyReactionEmojis = mapped
    }

    /**
     * @param value Return issues ordered by. Valid values are `created_at`, `updated_at`, `priority`, `due_date`, `relative_position`, `label_priority`, `milestone_due`, `popularity`, `weight`. Default is created_at
     */
    @JvmName("mfoguynqafmovwxi")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value The name or id of the project.
     */
    @JvmName("rdtogvoynkrfdamc")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value Return issues for the given scope. Valid values are `created_by_me`, `assigned_to_me`, `all`. Defaults to all.
     */
    @JvmName("wargxxftkdjmlyoq")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scope = mapped
    }

    /**
     * @param value Search project issues against their title and description
     */
    @JvmName("adshtfitkibpjnkx")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value Return issues sorted in asc or desc order. Default is desc
     */
    @JvmName("hasfjfwyqpuonwcr")
    public suspend fun sort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sort = mapped
    }

    /**
     * @param value Return issues updated on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     */
    @JvmName("jmyctkdkrtpoehig")
    public suspend fun updatedAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.updatedAfter = mapped
    }

    /**
     * @param value Return issues updated on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     */
    @JvmName("jktensvjblbhyucb")
    public suspend fun updatedBefore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.updatedBefore = mapped
    }

    /**
     * @param value Return issues with the specified weight. None returns issues with no weight assigned. Any returns issues with a weight assigned.
     */
    @JvmName("wjgmvckytyvnateg")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.weight = mapped
    }

    /**
     * @param value If true, the response returns more details for each label in labels field: :name, :color, :description, :description*html, :text*color. Default is false. description_html was introduced in GitLab 12.7
     */
    @JvmName("xddfvveuvdmdpajr")
    public suspend fun withLabelsDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withLabelsDetails = mapped
    }

    internal fun build(): GetProjectIssuesPlainArgs = GetProjectIssuesPlainArgs(
        assigneeId = assigneeId,
        assigneeUsername = assigneeUsername,
        authorId = authorId,
        confidential = confidential,
        createdAfter = createdAfter,
        createdBefore = createdBefore,
        dueDate = dueDate,
        iids = iids,
        issueType = issueType,
        labels = labels,
        milestone = milestone,
        myReactionEmoji = myReactionEmoji,
        notAssigneeIds = notAssigneeIds,
        notAuthorIds = notAuthorIds,
        notLabels = notLabels,
        notMilestone = notMilestone,
        notMyReactionEmojis = notMyReactionEmojis,
        orderBy = orderBy,
        project = project ?: throw PulumiNullFieldException("project"),
        scope = scope,
        search = search,
        sort = sort,
        updatedAfter = updatedAfter,
        updatedBefore = updatedBefore,
        weight = weight,
        withLabelsDetails = withLabelsDetails,
    )
}
