@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectMembershipPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectMembership.
 * @property fullPath The full path of the project.
 * @property inherited Return all project members including members through ancestor groups
 * @property projectId The ID of the project.
 * @property query A query string to search for members
 */
public data class GetProjectMembershipPlainArgs(
    public val fullPath: String? = null,
    public val inherited: Boolean? = null,
    public val projectId: Int? = null,
    public val query: String? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectMembershipPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectMembershipPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectMembershipPlainArgs.builder()
            .fullPath(fullPath?.let({ args0 -> args0 }))
            .inherited(inherited?.let({ args0 -> args0 }))
            .projectId(projectId?.let({ args0 -> args0 }))
            .query(query?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectMembershipPlainArgs].
 */
@PulumiTagMarker
public class GetProjectMembershipPlainArgsBuilder internal constructor() {
    private var fullPath: String? = null

    private var inherited: Boolean? = null

    private var projectId: Int? = null

    private var query: String? = null

    /**
     * @param value The full path of the project.
     */
    @JvmName("yvrnqknacknimptu")
    public suspend fun fullPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fullPath = mapped
    }

    /**
     * @param value Return all project members including members through ancestor groups
     */
    @JvmName("ovswncxbdxsyhvmg")
    public suspend fun inherited(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.inherited = mapped
    }

    /**
     * @param value The ID of the project.
     */
    @JvmName("pcdbfbgglimynyow")
    public suspend fun projectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.projectId = mapped
    }

    /**
     * @param value A query string to search for members
     */
    @JvmName("kqalbsrpkyalgnrh")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.query = mapped
    }

    internal fun build(): GetProjectMembershipPlainArgs = GetProjectMembershipPlainArgs(
        fullPath = fullPath,
        inherited = inherited,
        projectId = projectId,
        query = query,
    )
}
