@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectMilestonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectMilestone.
 * @property milestoneId The instance-wide ID of the project’s milestone.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 */
public data class GetProjectMilestonePlainArgs(
    public val milestoneId: Int,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectMilestonePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectMilestonePlainArgs =
        com.pulumi.gitlab.inputs.GetProjectMilestonePlainArgs.builder()
            .milestoneId(milestoneId.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectMilestonePlainArgs].
 */
@PulumiTagMarker
public class GetProjectMilestonePlainArgsBuilder internal constructor() {
    private var milestoneId: Int? = null

    private var project: String? = null

    /**
     * @param value The instance-wide ID of the project’s milestone.
     */
    @JvmName("uhhjgdvdopsrurom")
    public suspend fun milestoneId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.milestoneId = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("wxpjshihxosjykws")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectMilestonePlainArgs = GetProjectMilestonePlainArgs(
        milestoneId = milestoneId ?: throw PulumiNullFieldException("milestoneId"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
