@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectMilestonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectMilestones.
 * @property iids Return only the milestones having the given `iid` (Note: ignored if `include_parent_milestones` is set as `true`).
 * @property includeParentMilestones Include group milestones from parent group and its ancestors. Introduced in GitLab 13.4.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property search Return only milestones with a title or description matching the provided string.
 * @property state Return only `active` or `closed` milestones.
 * @property title Return only the milestones having the given `title`.
 */
public data class GetProjectMilestonesPlainArgs(
    public val iids: List<Int>? = null,
    public val includeParentMilestones: Boolean? = null,
    public val project: String,
    public val search: String? = null,
    public val state: String? = null,
    public val title: String? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectMilestonesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectMilestonesPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectMilestonesPlainArgs.builder()
            .iids(iids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeParentMilestones(includeParentMilestones?.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .title(title?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectMilestonesPlainArgs].
 */
@PulumiTagMarker
public class GetProjectMilestonesPlainArgsBuilder internal constructor() {
    private var iids: List<Int>? = null

    private var includeParentMilestones: Boolean? = null

    private var project: String? = null

    private var search: String? = null

    private var state: String? = null

    private var title: String? = null

    /**
     * @param value Return only the milestones having the given `iid` (Note: ignored if `include_parent_milestones` is set as `true`).
     */
    @JvmName("tofowxersbdhtrgi")
    public suspend fun iids(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.iids = mapped
    }

    /**
     * @param values Return only the milestones having the given `iid` (Note: ignored if `include_parent_milestones` is set as `true`).
     */
    @JvmName("dhbewgymknymsyon")
    public suspend fun iids(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iids = mapped
    }

    /**
     * @param value Include group milestones from parent group and its ancestors. Introduced in GitLab 13.4.
     */
    @JvmName("dibbrsstuupvuiwj")
    public suspend fun includeParentMilestones(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeParentMilestones = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("janhrsxmysjfbeqx")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value Return only milestones with a title or description matching the provided string.
     */
    @JvmName("eqsybdfhfxrrqmgl")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value Return only `active` or `closed` milestones.
     */
    @JvmName("yuvxxrglcespfotp")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Return only the milestones having the given `title`.
     */
    @JvmName("terbnrmvdbtcrhss")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.title = mapped
    }

    internal fun build(): GetProjectMilestonesPlainArgs = GetProjectMilestonesPlainArgs(
        iids = iids,
        includeParentMilestones = includeParentMilestones,
        project = project ?: throw PulumiNullFieldException("project"),
        search = search,
        state = state,
        title = title,
    )
}
