@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProject.
 * @property ciDefaultGitDepth Default number of revisions for shallow cloning.
 * @property id The integer that uniquely identifies the project within the gitlab install.
 * @property pathWithNamespace The path of the repository with namespace.
 * @property publicBuilds If true, jobs can be viewed by non-project members.
 */
public data class GetProjectPlainArgs(
    public val ciDefaultGitDepth: Int? = null,
    public val id: String? = null,
    public val pathWithNamespace: String? = null,
    public val publicBuilds: Boolean? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectPlainArgs.builder()
            .ciDefaultGitDepth(ciDefaultGitDepth?.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 }))
            .pathWithNamespace(pathWithNamespace?.let({ args0 -> args0 }))
            .publicBuilds(publicBuilds?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectPlainArgs].
 */
@PulumiTagMarker
public class GetProjectPlainArgsBuilder internal constructor() {
    private var ciDefaultGitDepth: Int? = null

    private var id: String? = null

    private var pathWithNamespace: String? = null

    private var publicBuilds: Boolean? = null

    /**
     * @param value Default number of revisions for shallow cloning.
     */
    @JvmName("phcwoebllsowvyjr")
    public suspend fun ciDefaultGitDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ciDefaultGitDepth = mapped
    }

    /**
     * @param value The integer that uniquely identifies the project within the gitlab install.
     */
    @JvmName("pefemgkqeookhyun")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The path of the repository with namespace.
     */
    @JvmName("nnwyrbaoxpyhdiir")
    public suspend fun pathWithNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pathWithNamespace = mapped
    }

    /**
     * @param value If true, jobs can be viewed by non-project members.
     */
    @JvmName("nioegfqdxnewkpli")
    public suspend fun publicBuilds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.publicBuilds = mapped
    }

    internal fun build(): GetProjectPlainArgs = GetProjectPlainArgs(
        ciDefaultGitDepth = ciDefaultGitDepth,
        id = id,
        pathWithNamespace = pathWithNamespace,
        publicBuilds = publicBuilds,
    )
}
