@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectProtectedBranchPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectProtectedBranch.
 * @property mergeAccessLevels Array of access levels and user(s)/group(s) allowed to merge to protected branch.
 * @property name The name of the protected branch.
 * @property projectId The integer or path with namespace that uniquely identifies the project.
 * @property pushAccessLevels Array of access levels and user(s)/group(s) allowed to push to protected branch.
 */
public data class GetProjectProtectedBranchPlainArgs(
    public val mergeAccessLevels: List<GetProjectProtectedBranchMergeAccessLevel>? = null,
    public val name: String,
    public val projectId: String,
    public val pushAccessLevels: List<GetProjectProtectedBranchPushAccessLevel>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectProtectedBranchPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectProtectedBranchPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectProtectedBranchPlainArgs.builder()
            .mergeAccessLevels(
                mergeAccessLevels?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.let({ args0 -> args0 }))
            .projectId(projectId.let({ args0 -> args0 }))
            .pushAccessLevels(
                pushAccessLevels?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetProjectProtectedBranchPlainArgs].
 */
@PulumiTagMarker
public class GetProjectProtectedBranchPlainArgsBuilder internal constructor() {
    private var mergeAccessLevels: List<GetProjectProtectedBranchMergeAccessLevel>? = null

    private var name: String? = null

    private var projectId: String? = null

    private var pushAccessLevels: List<GetProjectProtectedBranchPushAccessLevel>? = null

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("atqmqotbifskmacd")
    public suspend fun mergeAccessLevels(`value`: List<GetProjectProtectedBranchMergeAccessLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mergeAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("bjaweghanllttjll")
    public suspend fun mergeAccessLevels(argument: List<suspend GetProjectProtectedBranchMergeAccessLevelBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchMergeAccessLevelBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.mergeAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("agehetiopxqtoaoe")
    public suspend fun mergeAccessLevels(vararg argument: suspend GetProjectProtectedBranchMergeAccessLevelBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchMergeAccessLevelBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.mergeAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("gbiykjnjwwwaxftn")
    public suspend fun mergeAccessLevels(argument: suspend GetProjectProtectedBranchMergeAccessLevelBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetProjectProtectedBranchMergeAccessLevelBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.mergeAccessLevels = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("eixkheeficwonvne")
    public suspend fun mergeAccessLevels(vararg values: GetProjectProtectedBranchMergeAccessLevel) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mergeAccessLevels = mapped
    }

    /**
     * @param value The name of the protected branch.
     */
    @JvmName("hmqnjwviokvsdama")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The integer or path with namespace that uniquely identifies the project.
     */
    @JvmName("aywksiidxvdpuikm")
    public suspend fun projectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectId = mapped
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("jsjdfvqnddwethjs")
    public suspend fun pushAccessLevels(`value`: List<GetProjectProtectedBranchPushAccessLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pushAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("ntwmnqwhomxdierp")
    public suspend fun pushAccessLevels(argument: List<suspend GetProjectProtectedBranchPushAccessLevelBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchPushAccessLevelBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.pushAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("mdqwjidcphwgeelm")
    public suspend fun pushAccessLevels(vararg argument: suspend GetProjectProtectedBranchPushAccessLevelBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchPushAccessLevelBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.pushAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("elajmyoiyskuhnip")
    public suspend fun pushAccessLevels(argument: suspend GetProjectProtectedBranchPushAccessLevelBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetProjectProtectedBranchPushAccessLevelBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.pushAccessLevels = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("rvnvbiwlgyqcdebo")
    public suspend fun pushAccessLevels(vararg values: GetProjectProtectedBranchPushAccessLevel) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pushAccessLevels = mapped
    }

    internal fun build(): GetProjectProtectedBranchPlainArgs = GetProjectProtectedBranchPlainArgs(
        mergeAccessLevels = mergeAccessLevels,
        name = name ?: throw PulumiNullFieldException("name"),
        projectId = projectId ?: throw PulumiNullFieldException("projectId"),
        pushAccessLevels = pushAccessLevels,
    )
}
