@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectProtectedBranchesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectProtectedBranches.
 * @property projectId The integer or path with namespace that uniquely identifies the project.
 * @property protectedBranches A list of protected branches, as defined below.
 */
public data class GetProjectProtectedBranchesPlainArgs(
    public val projectId: String,
    public val protectedBranches: List<GetProjectProtectedBranchesProtectedBranch>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectProtectedBranchesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectProtectedBranchesPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectProtectedBranchesPlainArgs.builder()
            .projectId(projectId.let({ args0 -> args0 }))
            .protectedBranches(
                protectedBranches?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetProjectProtectedBranchesPlainArgs].
 */
@PulumiTagMarker
public class GetProjectProtectedBranchesPlainArgsBuilder internal constructor() {
    private var projectId: String? = null

    private var protectedBranches: List<GetProjectProtectedBranchesProtectedBranch>? = null

    /**
     * @param value The integer or path with namespace that uniquely identifies the project.
     */
    @JvmName("mhqjdkcxcpwrcqhe")
    public suspend fun projectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectId = mapped
    }

    /**
     * @param value A list of protected branches, as defined below.
     */
    @JvmName("pchjpvsagwiwsnqf")
    public suspend fun protectedBranches(`value`: List<GetProjectProtectedBranchesProtectedBranch>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protectedBranches = mapped
    }

    /**
     * @param argument A list of protected branches, as defined below.
     */
    @JvmName("loqsicueiyllhysd")
    public suspend fun protectedBranches(argument: List<suspend GetProjectProtectedBranchesProtectedBranchBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchesProtectedBranchBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.protectedBranches = mapped
    }

    /**
     * @param argument A list of protected branches, as defined below.
     */
    @JvmName("wfbdvffmevgfkkfi")
    public suspend fun protectedBranches(vararg argument: suspend GetProjectProtectedBranchesProtectedBranchBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchesProtectedBranchBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.protectedBranches = mapped
    }

    /**
     * @param argument A list of protected branches, as defined below.
     */
    @JvmName("pbatjkpqyfdpgtvm")
    public suspend fun protectedBranches(argument: suspend GetProjectProtectedBranchesProtectedBranchBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetProjectProtectedBranchesProtectedBranchBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.protectedBranches = mapped
    }

    /**
     * @param values A list of protected branches, as defined below.
     */
    @JvmName("jvcnmqfisgwhkmqo")
    public suspend fun protectedBranches(vararg values: GetProjectProtectedBranchesProtectedBranch) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectedBranches = mapped
    }

    internal fun build(): GetProjectProtectedBranchesPlainArgs = GetProjectProtectedBranchesPlainArgs(
        projectId = projectId ?: throw PulumiNullFieldException("projectId"),
        protectedBranches = protectedBranches,
    )
}
