@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranch.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowForcePush Whether force push is allowed.
 * @property codeOwnerApprovalRequired Reject code pushes that change files listed in the CODEOWNERS file.
 * @property id The ID of this resource.
 * @property mergeAccessLevels Array of access levels and user(s)/group(s) allowed to merge to protected branch.
 * @property name The name of the protected branch.
 * @property pushAccessLevels Array of access levels and user(s)/group(s) allowed to push to protected branch.
 */
public data class GetProjectProtectedBranchesProtectedBranch(
    public val allowForcePush: Boolean,
    public val codeOwnerApprovalRequired: Boolean,
    public val id: Int,
    public val mergeAccessLevels: List<GetProjectProtectedBranchesProtectedBranchMergeAccessLevel>? =
        null,
    public val name: String,
    public val pushAccessLevels: List<GetProjectProtectedBranchesProtectedBranchPushAccessLevel>? =
        null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranch> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranch =
        com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranch.builder()
            .allowForcePush(allowForcePush.let({ args0 -> args0 }))
            .codeOwnerApprovalRequired(codeOwnerApprovalRequired.let({ args0 -> args0 }))
            .id(id.let({ args0 -> args0 }))
            .mergeAccessLevels(
                mergeAccessLevels?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.let({ args0 -> args0 }))
            .pushAccessLevels(
                pushAccessLevels?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetProjectProtectedBranchesProtectedBranch].
 */
@PulumiTagMarker
public class GetProjectProtectedBranchesProtectedBranchBuilder internal constructor() {
    private var allowForcePush: Boolean? = null

    private var codeOwnerApprovalRequired: Boolean? = null

    private var id: Int? = null

    private var mergeAccessLevels: List<GetProjectProtectedBranchesProtectedBranchMergeAccessLevel>? =
        null

    private var name: String? = null

    private var pushAccessLevels: List<GetProjectProtectedBranchesProtectedBranchPushAccessLevel>? =
        null

    /**
     * @param value Whether force push is allowed.
     */
    @JvmName("hsdukkoervjgkxur")
    public suspend fun allowForcePush(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.allowForcePush = mapped
    }

    /**
     * @param value Reject code pushes that change files listed in the CODEOWNERS file.
     */
    @JvmName("qnkuflcsidrphmru")
    public suspend fun codeOwnerApprovalRequired(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.codeOwnerApprovalRequired = mapped
    }

    /**
     * @param value The ID of this resource.
     */
    @JvmName("ptlljalohrgmcjog")
    public suspend fun id(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("wjfmcjsicpihenmd")
    public suspend fun mergeAccessLevels(`value`: List<GetProjectProtectedBranchesProtectedBranchMergeAccessLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mergeAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("vltbrfcnkefncuix")
    public suspend fun mergeAccessLevels(argument: List<suspend GetProjectProtectedBranchesProtectedBranchMergeAccessLevelBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchesProtectedBranchMergeAccessLevelBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.mergeAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("ovixrxrdvgqbyavw")
    public suspend fun mergeAccessLevels(vararg argument: suspend GetProjectProtectedBranchesProtectedBranchMergeAccessLevelBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchesProtectedBranchMergeAccessLevelBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.mergeAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("munvqvntvoixrigh")
    public suspend fun mergeAccessLevels(argument: suspend GetProjectProtectedBranchesProtectedBranchMergeAccessLevelBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetProjectProtectedBranchesProtectedBranchMergeAccessLevelBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.mergeAccessLevels = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("uajrusgpuaajtykh")
    public suspend fun mergeAccessLevels(vararg values: GetProjectProtectedBranchesProtectedBranchMergeAccessLevel) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mergeAccessLevels = mapped
    }

    /**
     * @param value The name of the protected branch.
     */
    @JvmName("yckfdlxmugtvhjao")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("smqvremmgcbohcju")
    public suspend fun pushAccessLevels(`value`: List<GetProjectProtectedBranchesProtectedBranchPushAccessLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pushAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("jelptcsacjwbwbma")
    public suspend fun pushAccessLevels(argument: List<suspend GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.pushAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("vtpbnyiuihecqimg")
    public suspend fun pushAccessLevels(vararg argument: suspend GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.pushAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("pvmwgsfddvlfgroj")
    public suspend fun pushAccessLevels(argument: suspend GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.pushAccessLevels = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("bvqkbwrfmyavyxgx")
    public suspend fun pushAccessLevels(vararg values: GetProjectProtectedBranchesProtectedBranchPushAccessLevel) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pushAccessLevels = mapped
    }

    internal fun build(): GetProjectProtectedBranchesProtectedBranch =
        GetProjectProtectedBranchesProtectedBranch(
            allowForcePush = allowForcePush ?: throw PulumiNullFieldException("allowForcePush"),
            codeOwnerApprovalRequired = codeOwnerApprovalRequired ?: throw
                PulumiNullFieldException("codeOwnerApprovalRequired"),
            id = id ?: throw PulumiNullFieldException("id"),
            mergeAccessLevels = mergeAccessLevels,
            name = name ?: throw PulumiNullFieldException("name"),
            pushAccessLevels = pushAccessLevels,
        )
}
