@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevel.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessLevel Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
 * @property accessLevelDescription Readable description of access level.
 * @property groupId The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
 * @property userId The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
 */
public data class GetProjectProtectedBranchesProtectedBranchPushAccessLevel(
    public val accessLevel: String,
    public val accessLevelDescription: String,
    public val groupId: Int? = null,
    public val userId: Int? = null,
) :
    ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevel> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevel =
        com.pulumi.gitlab.inputs.GetProjectProtectedBranchesProtectedBranchPushAccessLevel.builder()
            .accessLevel(accessLevel.let({ args0 -> args0 }))
            .accessLevelDescription(accessLevelDescription.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .userId(userId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectProtectedBranchesProtectedBranchPushAccessLevel].
 */
@PulumiTagMarker
public class GetProjectProtectedBranchesProtectedBranchPushAccessLevelBuilder internal constructor() {
    private var accessLevel: String? = null

    private var accessLevelDescription: String? = null

    private var groupId: Int? = null

    private var userId: Int? = null

    /**
     * @param value Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("mmytmhxsfgcugchv")
    public suspend fun accessLevel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessLevel = mapped
    }

    /**
     * @param value Readable description of access level.
     */
    @JvmName("kygoajtkitwjqvja")
    public suspend fun accessLevelDescription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessLevelDescription = mapped
    }

    /**
     * @param value The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
     */
    @JvmName("wqgujpcrdnlfiwpp")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
     */
    @JvmName("ojlnmbsbiugfjxdr")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetProjectProtectedBranchesProtectedBranchPushAccessLevel =
        GetProjectProtectedBranchesProtectedBranchPushAccessLevel(
            accessLevel = accessLevel ?: throw PulumiNullFieldException("accessLevel"),
            accessLevelDescription = accessLevelDescription ?: throw
                PulumiNullFieldException("accessLevelDescription"),
            groupId = groupId,
            userId = userId,
        )
}
