@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectProtectedTagPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectProtectedTag.
 * @property project The integer or path with namespace that uniquely identifies the project.
 * @property tag The name of the protected tag.
 */
public data class GetProjectProtectedTagPlainArgs(
    public val project: String,
    public val tag: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectProtectedTagPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectProtectedTagPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectProtectedTagPlainArgs.builder()
            .project(project.let({ args0 -> args0 }))
            .tag(tag.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectProtectedTagPlainArgs].
 */
@PulumiTagMarker
public class GetProjectProtectedTagPlainArgsBuilder internal constructor() {
    private var project: String? = null

    private var tag: String? = null

    /**
     * @param value The integer or path with namespace that uniquely identifies the project.
     */
    @JvmName("hvqkowcpswrdbgju")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value The name of the protected tag.
     */
    @JvmName("sxhmysynpmddocjl")
    public suspend fun tag(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tag = mapped
    }

    internal fun build(): GetProjectProtectedTagPlainArgs = GetProjectProtectedTagPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
        tag = tag ?: throw PulumiNullFieldException("tag"),
    )
}
