@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectProtectedTagsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectProtectedTags.
 * @property project The integer or path with namespace that uniquely identifies the project.
 */
public data class GetProjectProtectedTagsPlainArgs(
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectProtectedTagsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectProtectedTagsPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectProtectedTagsPlainArgs.builder()
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectProtectedTagsPlainArgs].
 */
@PulumiTagMarker
public class GetProjectProtectedTagsPlainArgsBuilder internal constructor() {
    private var project: String? = null

    /**
     * @param value The integer or path with namespace that uniquely identifies the project.
     */
    @JvmName("lspwrmlfkxjbtpqi")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectProtectedTagsPlainArgs = GetProjectProtectedTagsPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
