@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectTagPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectTag.
 * @property name The name of a tag.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 */
public data class GetProjectTagPlainArgs(
    public val name: String,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectTagPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectTagPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectTagPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectTagPlainArgs].
 */
@PulumiTagMarker
public class GetProjectTagPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var project: String? = null

    /**
     * @param value The name of a tag.
     */
    @JvmName("kfttshsbvnvxbfji")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("sgwmaruhhvfpkpfw")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectTagPlainArgs = GetProjectTagPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
