@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectTagsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectTags.
 * @property orderBy Return tags ordered by `name` or `updated` fields. Default is `updated`.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property search Return list of tags matching the search criteria. You can use `^term` and `term$` to find tags that begin and end with `term` respectively. No other regular expressions are supported.
 * @property sort Return tags sorted in `asc` or `desc` order. Default is `desc`.
 */
public data class GetProjectTagsPlainArgs(
    public val orderBy: String? = null,
    public val project: String,
    public val search: String? = null,
    public val sort: String? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectTagsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectTagsPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectTagsPlainArgs.builder()
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .sort(sort?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectTagsPlainArgs].
 */
@PulumiTagMarker
public class GetProjectTagsPlainArgsBuilder internal constructor() {
    private var orderBy: String? = null

    private var project: String? = null

    private var search: String? = null

    private var sort: String? = null

    /**
     * @param value Return tags ordered by `name` or `updated` fields. Default is `updated`.
     */
    @JvmName("emmslpwappgdepqb")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("aomgflsabpdilouh")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value Return list of tags matching the search criteria. You can use `^term` and `term$` to find tags that begin and end with `term` respectively. No other regular expressions are supported.
     */
    @JvmName("lkhrmhcxqptrdeca")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value Return tags sorted in `asc` or `desc` order. Default is `desc`.
     */
    @JvmName("hudktpwnvxjuribq")
    public suspend fun sort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sort = mapped
    }

    internal fun build(): GetProjectTagsPlainArgs = GetProjectTagsPlainArgs(
        orderBy = orderBy,
        project = project ?: throw PulumiNullFieldException("project"),
        search = search,
        sort = sort,
    )
}
