@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectVariablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectVariable.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
 * @property key The name of the variable.
 * @property project The name or id of the project.
 */
public data class GetProjectVariablePlainArgs(
    public val environmentScope: String? = null,
    public val key: String,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectVariablePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectVariablePlainArgs =
        com.pulumi.gitlab.inputs.GetProjectVariablePlainArgs.builder()
            .environmentScope(environmentScope?.let({ args0 -> args0 }))
            .key(key.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectVariablePlainArgs].
 */
@PulumiTagMarker
public class GetProjectVariablePlainArgsBuilder internal constructor() {
    private var environmentScope: String? = null

    private var key: String? = null

    private var project: String? = null

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    @JvmName("xgcngjoppwrcrjkq")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.environmentScope = mapped
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("cbqaihrsvetjnfjp")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value The name or id of the project.
     */
    @JvmName("yfvnogeeleetjkbi")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectVariablePlainArgs = GetProjectVariablePlainArgs(
        environmentScope = environmentScope,
        key = key ?: throw PulumiNullFieldException("key"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
