@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectVariablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjectVariables.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`).
 * @property project The name or id of the project.
 */
public data class GetProjectVariablesPlainArgs(
    public val environmentScope: String? = null,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectVariablesPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectVariablesPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectVariablesPlainArgs.builder()
            .environmentScope(environmentScope?.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectVariablesPlainArgs].
 */
@PulumiTagMarker
public class GetProjectVariablesPlainArgsBuilder internal constructor() {
    private var environmentScope: String? = null

    private var project: String? = null

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`).
     */
    @JvmName("prtnkpbughdaxsgi")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.environmentScope = mapped
    }

    /**
     * @param value The name or id of the project.
     */
    @JvmName("bcyrqtrcbivdvppb")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetProjectVariablesPlainArgs = GetProjectVariablesPlainArgs(
        environmentScope = environmentScope,
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
