@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetProjectsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjects.
 * @property archived Limit by archived status.
 * @property groupId The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
 * @property includeSubgroups Include projects in subgroups of this group. Default is `false`. Needs `group_id`.
 * @property maxQueryablePages The maximum number of project results pages that may be queried. Prevents overloading your Gitlab instance in case of a misconfiguration.
 * @property membership Limit by projects that the current user is a member of.
 * @property minAccessLevel Limit to projects where current user has at least this access level, refer to the [official documentation](https://docs.gitlab.com/ee/api/members.html) for values. Cannot be used with `group_id`.
 * @property orderBy Return projects ordered ordered by: `id`, `name`, `path`, `created_at`, `updated_at`, `last_activity_at`, `similarity`, `repository_size`, `storage_size`, `packages_size`, `wiki_size`. Some values or only available in certain circumstances. See [upstream docs](https://docs.gitlab.com/ee/api/projects.html#list-all-projects) for details.
 * @property owned Limit by projects owned by the current user.
 * @property page The first page to begin the query on.
 * @property perPage The number of results to return per page.
 * @property search Return list of authorized projects matching the search criteria.
 * @property simple Return only the ID, URL, name, and path of each project.
 * @property sort Return projects sorted in `asc` or `desc` order. Default is `desc`.
 * @property starred Limit by projects starred by the current user.
 * @property statistics Include project statistics. Cannot be used with `group_id`.
 * @property topics Limit by projects that have all of the given topics.
 * @property visibility Limit by visibility `public`, `internal`, or `private`.
 * @property withCustomAttributes Include custom attributes in response *(admins only)*.
 * @property withIssuesEnabled Limit by projects with issues feature enabled. Default is `false`.
 * @property withMergeRequestsEnabled Limit by projects with merge requests feature enabled. Default is `false`.
 * @property withProgrammingLanguage Limit by projects which use the given programming language. Cannot be used with `group_id`.
 * @property withShared Include projects shared to this group. Default is `true`. Needs `group_id`.
 */
public data class GetProjectsPlainArgs(
    public val archived: Boolean? = null,
    public val groupId: Int? = null,
    public val includeSubgroups: Boolean? = null,
    public val maxQueryablePages: Int? = null,
    public val membership: Boolean? = null,
    public val minAccessLevel: Int? = null,
    public val orderBy: String? = null,
    public val owned: Boolean? = null,
    public val page: Int? = null,
    public val perPage: Int? = null,
    public val search: String? = null,
    public val simple: Boolean? = null,
    public val sort: String? = null,
    public val starred: Boolean? = null,
    public val statistics: Boolean? = null,
    public val topics: List<String>? = null,
    public val visibility: String? = null,
    public val withCustomAttributes: Boolean? = null,
    public val withIssuesEnabled: Boolean? = null,
    public val withMergeRequestsEnabled: Boolean? = null,
    public val withProgrammingLanguage: String? = null,
    public val withShared: Boolean? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetProjectsPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetProjectsPlainArgs =
        com.pulumi.gitlab.inputs.GetProjectsPlainArgs.builder()
            .archived(archived?.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .includeSubgroups(includeSubgroups?.let({ args0 -> args0 }))
            .maxQueryablePages(maxQueryablePages?.let({ args0 -> args0 }))
            .membership(membership?.let({ args0 -> args0 }))
            .minAccessLevel(minAccessLevel?.let({ args0 -> args0 }))
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .owned(owned?.let({ args0 -> args0 }))
            .page(page?.let({ args0 -> args0 }))
            .perPage(perPage?.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .simple(simple?.let({ args0 -> args0 }))
            .sort(sort?.let({ args0 -> args0 }))
            .starred(starred?.let({ args0 -> args0 }))
            .statistics(statistics?.let({ args0 -> args0 }))
            .topics(topics?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .visibility(visibility?.let({ args0 -> args0 }))
            .withCustomAttributes(withCustomAttributes?.let({ args0 -> args0 }))
            .withIssuesEnabled(withIssuesEnabled?.let({ args0 -> args0 }))
            .withMergeRequestsEnabled(withMergeRequestsEnabled?.let({ args0 -> args0 }))
            .withProgrammingLanguage(withProgrammingLanguage?.let({ args0 -> args0 }))
            .withShared(withShared?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectsPlainArgs].
 */
@PulumiTagMarker
public class GetProjectsPlainArgsBuilder internal constructor() {
    private var archived: Boolean? = null

    private var groupId: Int? = null

    private var includeSubgroups: Boolean? = null

    private var maxQueryablePages: Int? = null

    private var membership: Boolean? = null

    private var minAccessLevel: Int? = null

    private var orderBy: String? = null

    private var owned: Boolean? = null

    private var page: Int? = null

    private var perPage: Int? = null

    private var search: String? = null

    private var simple: Boolean? = null

    private var sort: String? = null

    private var starred: Boolean? = null

    private var statistics: Boolean? = null

    private var topics: List<String>? = null

    private var visibility: String? = null

    private var withCustomAttributes: Boolean? = null

    private var withIssuesEnabled: Boolean? = null

    private var withMergeRequestsEnabled: Boolean? = null

    private var withProgrammingLanguage: String? = null

    private var withShared: Boolean? = null

    /**
     * @param value Limit by archived status.
     */
    @JvmName("ossywbtycrmredvc")
    public suspend fun archived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.archived = mapped
    }

    /**
     * @param value The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
     */
    @JvmName("gugpadaergeivfgp")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value Include projects in subgroups of this group. Default is `false`. Needs `group_id`.
     */
    @JvmName("gtljbvldjlitiixb")
    public suspend fun includeSubgroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeSubgroups = mapped
    }

    /**
     * @param value The maximum number of project results pages that may be queried. Prevents overloading your Gitlab instance in case of a misconfiguration.
     */
    @JvmName("ochowuiadqmhwdwk")
    public suspend fun maxQueryablePages(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxQueryablePages = mapped
    }

    /**
     * @param value Limit by projects that the current user is a member of.
     */
    @JvmName("tayjbnukawkqydkp")
    public suspend fun membership(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.membership = mapped
    }

    /**
     * @param value Limit to projects where current user has at least this access level, refer to the [official documentation](https://docs.gitlab.com/ee/api/members.html) for values. Cannot be used with `group_id`.
     */
    @JvmName("klnpihempecubqht")
    public suspend fun minAccessLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.minAccessLevel = mapped
    }

    /**
     * @param value Return projects ordered ordered by: `id`, `name`, `path`, `created_at`, `updated_at`, `last_activity_at`, `similarity`, `repository_size`, `storage_size`, `packages_size`, `wiki_size`. Some values or only available in certain circumstances. See [upstream docs](https://docs.gitlab.com/ee/api/projects.html#list-all-projects) for details.
     */
    @JvmName("wrstfrgshprmrcmk")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value Limit by projects owned by the current user.
     */
    @JvmName("noxrhwgkjtneesvx")
    public suspend fun owned(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owned = mapped
    }

    /**
     * @param value The first page to begin the query on.
     */
    @JvmName("rtbhaltrretljsiv")
    public suspend fun page(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.page = mapped
    }

    /**
     * @param value The number of results to return per page.
     */
    @JvmName("puuvtisbbepsgwmw")
    public suspend fun perPage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.perPage = mapped
    }

    /**
     * @param value Return list of authorized projects matching the search criteria.
     */
    @JvmName("fegxkpacdutiqeds")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value Return only the ID, URL, name, and path of each project.
     */
    @JvmName("jpsyedoporothbrs")
    public suspend fun simple(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.simple = mapped
    }

    /**
     * @param value Return projects sorted in `asc` or `desc` order. Default is `desc`.
     */
    @JvmName("aphtkoclyjvsymgh")
    public suspend fun sort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sort = mapped
    }

    /**
     * @param value Limit by projects starred by the current user.
     */
    @JvmName("mcsyeqyufiurdaud")
    public suspend fun starred(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.starred = mapped
    }

    /**
     * @param value Include project statistics. Cannot be used with `group_id`.
     */
    @JvmName("iffybbconvrepuof")
    public suspend fun statistics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statistics = mapped
    }

    /**
     * @param value Limit by projects that have all of the given topics.
     */
    @JvmName("heaioawoyigsirea")
    public suspend fun topics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.topics = mapped
    }

    /**
     * @param values Limit by projects that have all of the given topics.
     */
    @JvmName("ebubqawiqlyoqsyg")
    public suspend fun topics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topics = mapped
    }

    /**
     * @param value Limit by visibility `public`, `internal`, or `private`.
     */
    @JvmName("payerufwoagpkslk")
    public suspend fun visibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.visibility = mapped
    }

    /**
     * @param value Include custom attributes in response *(admins only)*.
     */
    @JvmName("ncclyhnolrdaiyww")
    public suspend fun withCustomAttributes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withCustomAttributes = mapped
    }

    /**
     * @param value Limit by projects with issues feature enabled. Default is `false`.
     */
    @JvmName("voptdojedcayloxw")
    public suspend fun withIssuesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withIssuesEnabled = mapped
    }

    /**
     * @param value Limit by projects with merge requests feature enabled. Default is `false`.
     */
    @JvmName("uvoiexnrjjaphuyi")
    public suspend fun withMergeRequestsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withMergeRequestsEnabled = mapped
    }

    /**
     * @param value Limit by projects which use the given programming language. Cannot be used with `group_id`.
     */
    @JvmName("hwrqbvqgflwllqkn")
    public suspend fun withProgrammingLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withProgrammingLanguage = mapped
    }

    /**
     * @param value Include projects shared to this group. Default is `true`. Needs `group_id`.
     */
    @JvmName("lqniwiswcgptsbgp")
    public suspend fun withShared(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withShared = mapped
    }

    internal fun build(): GetProjectsPlainArgs = GetProjectsPlainArgs(
        archived = archived,
        groupId = groupId,
        includeSubgroups = includeSubgroups,
        maxQueryablePages = maxQueryablePages,
        membership = membership,
        minAccessLevel = minAccessLevel,
        orderBy = orderBy,
        owned = owned,
        page = page,
        perPage = perPage,
        search = search,
        simple = simple,
        sort = sort,
        starred = starred,
        statistics = statistics,
        topics = topics,
        visibility = visibility,
        withCustomAttributes = withCustomAttributes,
        withIssuesEnabled = withIssuesEnabled,
        withMergeRequestsEnabled = withMergeRequestsEnabled,
        withProgrammingLanguage = withProgrammingLanguage,
        withShared = withShared,
    )
}
