@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetReleaseAssets.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property count The number of assets for a release
 * @property links The links for a release
 * @property sources The sources for a release
 */
public data class GetReleaseAssets(
    public val count: Int,
    public val links: List<GetReleaseAssetsLink>? = null,
    public val sources: List<GetReleaseAssetsSource>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetReleaseAssets> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetReleaseAssets =
        com.pulumi.gitlab.inputs.GetReleaseAssets.builder()
            .count(count.let({ args0 -> args0 }))
            .links(links?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sources(
                sources?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetReleaseAssets].
 */
@PulumiTagMarker
public class GetReleaseAssetsBuilder internal constructor() {
    private var count: Int? = null

    private var links: List<GetReleaseAssetsLink>? = null

    private var sources: List<GetReleaseAssetsSource>? = null

    /**
     * @param value The number of assets for a release
     */
    @JvmName("obcexnojfcdxfjro")
    public suspend fun count(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.count = mapped
    }

    /**
     * @param value The links for a release
     */
    @JvmName("lusxaokvrqkyyfmc")
    public suspend fun links(`value`: List<GetReleaseAssetsLink>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.links = mapped
    }

    /**
     * @param argument The links for a release
     */
    @JvmName("vsdmfwawdayewqui")
    public suspend fun links(argument: List<suspend GetReleaseAssetsLinkBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetReleaseAssetsLinkBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.links = mapped
    }

    /**
     * @param argument The links for a release
     */
    @JvmName("vhdtvwexvfdvhvas")
    public suspend fun links(vararg argument: suspend GetReleaseAssetsLinkBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetReleaseAssetsLinkBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.links = mapped
    }

    /**
     * @param argument The links for a release
     */
    @JvmName("xbtawqpeigkhjdbq")
    public suspend fun links(argument: suspend GetReleaseAssetsLinkBuilder.() -> Unit) {
        val toBeMapped = listOf(GetReleaseAssetsLinkBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.links = mapped
    }

    /**
     * @param values The links for a release
     */
    @JvmName("qjvpjsoeudysnmlw")
    public suspend fun links(vararg values: GetReleaseAssetsLink) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.links = mapped
    }

    /**
     * @param value The sources for a release
     */
    @JvmName("dufawyufsopimetv")
    public suspend fun sources(`value`: List<GetReleaseAssetsSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sources = mapped
    }

    /**
     * @param argument The sources for a release
     */
    @JvmName("vxumdqvpstaoxbgv")
    public suspend fun sources(argument: List<suspend GetReleaseAssetsSourceBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetReleaseAssetsSourceBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.sources = mapped
    }

    /**
     * @param argument The sources for a release
     */
    @JvmName("xrpguppssskxkbol")
    public suspend fun sources(vararg argument: suspend GetReleaseAssetsSourceBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetReleaseAssetsSourceBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.sources = mapped
    }

    /**
     * @param argument The sources for a release
     */
    @JvmName("ybghijevswhrirtm")
    public suspend fun sources(argument: suspend GetReleaseAssetsSourceBuilder.() -> Unit) {
        val toBeMapped = listOf(GetReleaseAssetsSourceBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.sources = mapped
    }

    /**
     * @param values The sources for a release
     */
    @JvmName("vunvnfpnymioiiad")
    public suspend fun sources(vararg values: GetReleaseAssetsSource) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sources = mapped
    }

    internal fun build(): GetReleaseAssets = GetReleaseAssets(
        count = count ?: throw PulumiNullFieldException("count"),
        links = links,
        sources = sources,
    )
}
