@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetReleaseAssetsLink.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the link
 * @property linkType The type of the link
 * @property name The name of the link
 * @property url The URL of the link
 */
public data class GetReleaseAssetsLink(
    public val id: Int,
    public val linkType: String,
    public val name: String,
    public val url: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetReleaseAssetsLink> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetReleaseAssetsLink =
        com.pulumi.gitlab.inputs.GetReleaseAssetsLink.builder()
            .id(id.let({ args0 -> args0 }))
            .linkType(linkType.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .url(url.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReleaseAssetsLink].
 */
@PulumiTagMarker
public class GetReleaseAssetsLinkBuilder internal constructor() {
    private var id: Int? = null

    private var linkType: String? = null

    private var name: String? = null

    private var url: String? = null

    /**
     * @param value The ID of the link
     */
    @JvmName("tnxhxdwtofmwnwjk")
    public suspend fun id(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The type of the link
     */
    @JvmName("frdyfomffctqgyht")
    public suspend fun linkType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkType = mapped
    }

    /**
     * @param value The name of the link
     */
    @JvmName("kjwxkrdjapivavor")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The URL of the link
     */
    @JvmName("kihiiodswcygxhnt")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.url = mapped
    }

    internal fun build(): GetReleaseAssetsLink = GetReleaseAssetsLink(
        id = id ?: throw PulumiNullFieldException("id"),
        linkType = linkType ?: throw PulumiNullFieldException("linkType"),
        name = name ?: throw PulumiNullFieldException("name"),
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
