@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetReleaseAssetsSource.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format The format of the source
 * @property url The URL of the source
 */
public data class GetReleaseAssetsSource(
    public val format: String,
    public val url: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetReleaseAssetsSource> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetReleaseAssetsSource =
        com.pulumi.gitlab.inputs.GetReleaseAssetsSource.builder()
            .format(format.let({ args0 -> args0 }))
            .url(url.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReleaseAssetsSource].
 */
@PulumiTagMarker
public class GetReleaseAssetsSourceBuilder internal constructor() {
    private var format: String? = null

    private var url: String? = null

    /**
     * @param value The format of the source
     */
    @JvmName("kkymkiapwjerhrgo")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value The URL of the source
     */
    @JvmName("puxlivbucjuvbewb")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.url = mapped
    }

    internal fun build(): GetReleaseAssetsSource = GetReleaseAssetsSource(
        format = format ?: throw PulumiNullFieldException("format"),
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
