@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetReleaseLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReleaseLink.
 * @property linkId The ID of the link.
 * @property project The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
 * @property tagName The tag associated with the Release.
 */
public data class GetReleaseLinkPlainArgs(
    public val linkId: Int,
    public val project: String,
    public val tagName: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetReleaseLinkPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetReleaseLinkPlainArgs =
        com.pulumi.gitlab.inputs.GetReleaseLinkPlainArgs.builder()
            .linkId(linkId.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 }))
            .tagName(tagName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReleaseLinkPlainArgs].
 */
@PulumiTagMarker
public class GetReleaseLinkPlainArgsBuilder internal constructor() {
    private var linkId: Int? = null

    private var project: String? = null

    private var tagName: String? = null

    /**
     * @param value The ID of the link.
     */
    @JvmName("vdduenjlidigyrlf")
    public suspend fun linkId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkId = mapped
    }

    /**
     * @param value The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
     */
    @JvmName("hbgcqcuwxgpgaivs")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value The tag associated with the Release.
     */
    @JvmName("qdmffuumondxioem")
    public suspend fun tagName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagName = mapped
    }

    internal fun build(): GetReleaseLinkPlainArgs = GetReleaseLinkPlainArgs(
        linkId = linkId ?: throw PulumiNullFieldException("linkId"),
        project = project ?: throw PulumiNullFieldException("project"),
        tagName = tagName ?: throw PulumiNullFieldException("tagName"),
    )
}
