@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetReleaseLinksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReleaseLinks.
 * @property project The ID or full path to the project.
 * @property tagName The tag associated with the Release.
 */
public data class GetReleaseLinksPlainArgs(
    public val project: String,
    public val tagName: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetReleaseLinksPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetReleaseLinksPlainArgs =
        com.pulumi.gitlab.inputs.GetReleaseLinksPlainArgs.builder()
            .project(project.let({ args0 -> args0 }))
            .tagName(tagName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReleaseLinksPlainArgs].
 */
@PulumiTagMarker
public class GetReleaseLinksPlainArgsBuilder internal constructor() {
    private var project: String? = null

    private var tagName: String? = null

    /**
     * @param value The ID or full path to the project.
     */
    @JvmName("estowqrkovoqsifo")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value The tag associated with the Release.
     */
    @JvmName("qfopgfhdqcvteyqx")
    public suspend fun tagName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagName = mapped
    }

    internal fun build(): GetReleaseLinksPlainArgs = GetReleaseLinksPlainArgs(
        project = project ?: throw PulumiNullFieldException("project"),
        tagName = tagName ?: throw PulumiNullFieldException("tagName"),
    )
}
