@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetReleasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRelease.
 * @property assets The assets for a release
 * @property projectId The ID or URL-encoded path of the project.
 * @property tagName The Git tag the release is associated with.
 */
public data class GetReleasePlainArgs(
    public val assets: GetReleaseAssets? = null,
    public val projectId: String,
    public val tagName: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetReleasePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetReleasePlainArgs =
        com.pulumi.gitlab.inputs.GetReleasePlainArgs.builder()
            .assets(assets?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .projectId(projectId.let({ args0 -> args0 }))
            .tagName(tagName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReleasePlainArgs].
 */
@PulumiTagMarker
public class GetReleasePlainArgsBuilder internal constructor() {
    private var assets: GetReleaseAssets? = null

    private var projectId: String? = null

    private var tagName: String? = null

    /**
     * @param value The assets for a release
     */
    @JvmName("oamomnaayydrxnay")
    public suspend fun assets(`value`: GetReleaseAssets?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.assets = mapped
    }

    /**
     * @param argument The assets for a release
     */
    @JvmName("qpqbhifxvsusjcim")
    public suspend fun assets(argument: suspend GetReleaseAssetsBuilder.() -> Unit) {
        val toBeMapped = GetReleaseAssetsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.assets = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project.
     */
    @JvmName("edijwwxanfbqdesc")
    public suspend fun projectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectId = mapped
    }

    /**
     * @param value The Git tag the release is associated with.
     */
    @JvmName("uoxtoobtiwpidbdi")
    public suspend fun tagName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagName = mapped
    }

    internal fun build(): GetReleasePlainArgs = GetReleasePlainArgs(
        assets = assets,
        projectId = projectId ?: throw PulumiNullFieldException("projectId"),
        tagName = tagName ?: throw PulumiNullFieldException("tagName"),
    )
}
