@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetRepositoryFilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepositoryFile.
 * @property filePath The full path of the file. It must be relative to the root of the project without a leading slash `/` or `./`.
 * @property project The name or ID of the project.
 * @property ref The name of branch, tag or commit.
 */
public data class GetRepositoryFilePlainArgs(
    public val filePath: String,
    public val project: String,
    public val ref: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetRepositoryFilePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetRepositoryFilePlainArgs =
        com.pulumi.gitlab.inputs.GetRepositoryFilePlainArgs.builder()
            .filePath(filePath.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 }))
            .ref(ref.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRepositoryFilePlainArgs].
 */
@PulumiTagMarker
public class GetRepositoryFilePlainArgsBuilder internal constructor() {
    private var filePath: String? = null

    private var project: String? = null

    private var ref: String? = null

    /**
     * @param value The full path of the file. It must be relative to the root of the project without a leading slash `/` or `./`.
     */
    @JvmName("hxjyvolnfaofwfdy")
    public suspend fun filePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filePath = mapped
    }

    /**
     * @param value The name or ID of the project.
     */
    @JvmName("wwcestaitlnptfan")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value The name of branch, tag or commit.
     */
    @JvmName("eilwigvmnhjhicyi")
    public suspend fun ref(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ref = mapped
    }

    internal fun build(): GetRepositoryFilePlainArgs = GetRepositoryFilePlainArgs(
        filePath = filePath ?: throw PulumiNullFieldException("filePath"),
        project = project ?: throw PulumiNullFieldException("project"),
        ref = ref ?: throw PulumiNullFieldException("ref"),
    )
}
