@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetRepositoryTreePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepositoryTree.
 * @property path The path inside repository. Used to get content of subdirectories.
 * @property project The ID or full path of the project owned by the authenticated user.
 * @property recursive Boolean value used to get a recursive tree (false by default).
 * @property ref The name of a repository branch or tag.
 */
public data class GetRepositoryTreePlainArgs(
    public val path: String? = null,
    public val project: String,
    public val recursive: Boolean? = null,
    public val ref: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetRepositoryTreePlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetRepositoryTreePlainArgs =
        com.pulumi.gitlab.inputs.GetRepositoryTreePlainArgs.builder()
            .path(path?.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 }))
            .recursive(recursive?.let({ args0 -> args0 }))
            .ref(ref.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRepositoryTreePlainArgs].
 */
@PulumiTagMarker
public class GetRepositoryTreePlainArgsBuilder internal constructor() {
    private var path: String? = null

    private var project: String? = null

    private var recursive: Boolean? = null

    private var ref: String? = null

    /**
     * @param value The path inside repository. Used to get content of subdirectories.
     */
    @JvmName("pelwaxteqmuioeoa")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.path = mapped
    }

    /**
     * @param value The ID or full path of the project owned by the authenticated user.
     */
    @JvmName("mqctydivycnkqbni")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value Boolean value used to get a recursive tree (false by default).
     */
    @JvmName("hbdkckyushuwldqa")
    public suspend fun recursive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.recursive = mapped
    }

    /**
     * @param value The name of a repository branch or tag.
     */
    @JvmName("oskiethloadtmhyc")
    public suspend fun ref(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ref = mapped
    }

    internal fun build(): GetRepositoryTreePlainArgs = GetRepositoryTreePlainArgs(
        path = path,
        project = project ?: throw PulumiNullFieldException("project"),
        recursive = recursive,
        ref = ref ?: throw PulumiNullFieldException("ref"),
    )
}
