@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUser.
 * @property email The public email address of the user. **Note**: before GitLab 14.8 the lookup was based on the users primary email address.
 * @property namespaceId The ID of the user's namespace. Requires admin token to access this field. Available since GitLab 14.10.
 * @property userId The ID of the user.
 * @property username The username of the user.
 */
public data class GetUserPlainArgs(
    public val email: String? = null,
    public val namespaceId: Int? = null,
    public val userId: Int? = null,
    public val username: String? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetUserPlainArgs =
        com.pulumi.gitlab.inputs.GetUserPlainArgs.builder()
            .email(email?.let({ args0 -> args0 }))
            .namespaceId(namespaceId?.let({ args0 -> args0 }))
            .userId(userId?.let({ args0 -> args0 }))
            .username(username?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var email: String? = null

    private var namespaceId: Int? = null

    private var userId: Int? = null

    private var username: String? = null

    /**
     * @param value The public email address of the user. **Note**: before GitLab 14.8 the lookup was based on the users primary email address.
     */
    @JvmName("fppujhrasjtpmhid")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.email = mapped
    }

    /**
     * @param value The ID of the user's namespace. Requires admin token to access this field. Available since GitLab 14.10.
     */
    @JvmName("xiirohbbjlgmbljl")
    public suspend fun namespaceId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespaceId = mapped
    }

    /**
     * @param value The ID of the user.
     */
    @JvmName("gwpumcjdqncsmsgy")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    /**
     * @param value The username of the user.
     */
    @JvmName("tsweiexdwurmjtei")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.username = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        email = email,
        namespaceId = namespaceId,
        userId = userId,
        username = username,
    )
}
