@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetUserSshkeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserSshkeys.
 * @property userId ID of the user to get the SSH keys for.
 * @property username Username of the user to get the SSH keys for.
 */
public data class GetUserSshkeysPlainArgs(
    public val userId: Int? = null,
    public val username: String? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetUserSshkeysPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetUserSshkeysPlainArgs =
        com.pulumi.gitlab.inputs.GetUserSshkeysPlainArgs.builder()
            .userId(userId?.let({ args0 -> args0 }))
            .username(username?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserSshkeysPlainArgs].
 */
@PulumiTagMarker
public class GetUserSshkeysPlainArgsBuilder internal constructor() {
    private var userId: Int? = null

    private var username: String? = null

    /**
     * @param value ID of the user to get the SSH keys for.
     */
    @JvmName("dexldqbimijfpxqw")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    /**
     * @param value Username of the user to get the SSH keys for.
     */
    @JvmName("hkamgldkyycxhipf")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.username = mapped
    }

    internal fun build(): GetUserSshkeysPlainArgs = GetUserSshkeysPlainArgs(
        userId = userId,
        username = username,
    )
}
