@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupAccessTokenRotationConfigurationArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expirationDays The duration (in days) the new token should be valid for.
 * @property rotateBeforeDays The duration (in days) before the expiration when the token should be rotated. As an example, if set to 7 days, the token will rotate 7 days before the expiration date, but only when `pulumi up` is run in that timeframe.
 */
public data class GroupAccessTokenRotationConfigurationArgs(
    public val expirationDays: Output<Int>,
    public val rotateBeforeDays: Output<Int>,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupAccessTokenRotationConfigurationArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupAccessTokenRotationConfigurationArgs =
        com.pulumi.gitlab.inputs.GroupAccessTokenRotationConfigurationArgs.builder()
            .expirationDays(expirationDays.applyValue({ args0 -> args0 }))
            .rotateBeforeDays(rotateBeforeDays.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupAccessTokenRotationConfigurationArgs].
 */
@PulumiTagMarker
public class GroupAccessTokenRotationConfigurationArgsBuilder internal constructor() {
    private var expirationDays: Output<Int>? = null

    private var rotateBeforeDays: Output<Int>? = null

    /**
     * @param value The duration (in days) the new token should be valid for.
     */
    @JvmName("iwvpqtkpnfpmcndt")
    public suspend fun expirationDays(`value`: Output<Int>) {
        this.expirationDays = value
    }

    /**
     * @param value The duration (in days) before the expiration when the token should be rotated. As an example, if set to 7 days, the token will rotate 7 days before the expiration date, but only when `pulumi up` is run in that timeframe.
     */
    @JvmName("hyimceohmrkwrxsu")
    public suspend fun rotateBeforeDays(`value`: Output<Int>) {
        this.rotateBeforeDays = value
    }

    /**
     * @param value The duration (in days) the new token should be valid for.
     */
    @JvmName("namaqiryugvsoqyi")
    public suspend fun expirationDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirationDays = mapped
    }

    /**
     * @param value The duration (in days) before the expiration when the token should be rotated. As an example, if set to 7 days, the token will rotate 7 days before the expiration date, but only when `pulumi up` is run in that timeframe.
     */
    @JvmName("ctyaffeenogaefta")
    public suspend fun rotateBeforeDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rotateBeforeDays = mapped
    }

    internal fun build(): GroupAccessTokenRotationConfigurationArgs =
        GroupAccessTokenRotationConfigurationArgs(
            expirationDays = expirationDays ?: throw PulumiNullFieldException("expirationDays"),
            rotateBeforeDays = rotateBeforeDays ?: throw PulumiNullFieldException("rotateBeforeDays"),
        )
}
