@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupDefaultBranchProtectionDefaultsArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowForcePush Allow force push for all users with push access.
 * @property allowedToMerges An array of access levels allowed to merge. Valid values are: `developer`, `maintainer`.
 * @property allowedToPushes An array of access levels allowed to push. Valid values are: `developer`, `maintainer`.
 * @property developerCanInitialPush Allow developers to initial push.
 */
public data class GroupDefaultBranchProtectionDefaultsArgs(
    public val allowForcePush: Output<Boolean>? = null,
    public val allowedToMerges: Output<List<String>>? = null,
    public val allowedToPushes: Output<List<String>>? = null,
    public val developerCanInitialPush: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupDefaultBranchProtectionDefaultsArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupDefaultBranchProtectionDefaultsArgs =
        com.pulumi.gitlab.inputs.GroupDefaultBranchProtectionDefaultsArgs.builder()
            .allowForcePush(allowForcePush?.applyValue({ args0 -> args0 }))
            .allowedToMerges(allowedToMerges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedToPushes(allowedToPushes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .developerCanInitialPush(developerCanInitialPush?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupDefaultBranchProtectionDefaultsArgs].
 */
@PulumiTagMarker
public class GroupDefaultBranchProtectionDefaultsArgsBuilder internal constructor() {
    private var allowForcePush: Output<Boolean>? = null

    private var allowedToMerges: Output<List<String>>? = null

    private var allowedToPushes: Output<List<String>>? = null

    private var developerCanInitialPush: Output<Boolean>? = null

    /**
     * @param value Allow force push for all users with push access.
     */
    @JvmName("fwgmydgayiwnjnpc")
    public suspend fun allowForcePush(`value`: Output<Boolean>) {
        this.allowForcePush = value
    }

    /**
     * @param value An array of access levels allowed to merge. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("jcgeylgwiyslunjh")
    public suspend fun allowedToMerges(`value`: Output<List<String>>) {
        this.allowedToMerges = value
    }

    @JvmName("yuteweykpbpmgflf")
    public suspend fun allowedToMerges(vararg values: Output<String>) {
        this.allowedToMerges = Output.all(values.asList())
    }

    /**
     * @param values An array of access levels allowed to merge. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("pvgrmhtghfrjwucr")
    public suspend fun allowedToMerges(values: List<Output<String>>) {
        this.allowedToMerges = Output.all(values)
    }

    /**
     * @param value An array of access levels allowed to push. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("bsbumnnwmelsvoou")
    public suspend fun allowedToPushes(`value`: Output<List<String>>) {
        this.allowedToPushes = value
    }

    @JvmName("thonjqfdsihvkjjf")
    public suspend fun allowedToPushes(vararg values: Output<String>) {
        this.allowedToPushes = Output.all(values.asList())
    }

    /**
     * @param values An array of access levels allowed to push. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("fmwqcxvmabjggkip")
    public suspend fun allowedToPushes(values: List<Output<String>>) {
        this.allowedToPushes = Output.all(values)
    }

    /**
     * @param value Allow developers to initial push.
     */
    @JvmName("prfwefkvysjrrsib")
    public suspend fun developerCanInitialPush(`value`: Output<Boolean>) {
        this.developerCanInitialPush = value
    }

    /**
     * @param value Allow force push for all users with push access.
     */
    @JvmName("ajhwinluupsycsyb")
    public suspend fun allowForcePush(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowForcePush = mapped
    }

    /**
     * @param value An array of access levels allowed to merge. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("irasmubdgxspihkh")
    public suspend fun allowedToMerges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToMerges = mapped
    }

    /**
     * @param values An array of access levels allowed to merge. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("lpjkdflakqacowgw")
    public suspend fun allowedToMerges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToMerges = mapped
    }

    /**
     * @param value An array of access levels allowed to push. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("vtrwicjxeamedcbn")
    public suspend fun allowedToPushes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToPushes = mapped
    }

    /**
     * @param values An array of access levels allowed to push. Valid values are: `developer`, `maintainer`.
     */
    @JvmName("vhfqymwsanmprdpu")
    public suspend fun allowedToPushes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToPushes = mapped
    }

    /**
     * @param value Allow developers to initial push.
     */
    @JvmName("cpftostawnwssili")
    public suspend fun developerCanInitialPush(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerCanInitialPush = mapped
    }

    internal fun build(): GroupDefaultBranchProtectionDefaultsArgs =
        GroupDefaultBranchProtectionDefaultsArgs(
            allowForcePush = allowForcePush,
            allowedToMerges = allowedToMerges,
            allowedToPushes = allowedToPushes,
            developerCanInitialPush = developerCanInitialPush,
        )
}
