@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupEpicBoardListArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the list.
 * @property labelId The ID of the label the list should be scoped to.
 * @property position The position of the list within the board. The position for the list is sed on the its position in the `lists` array.
 */
public data class GroupEpicBoardListArgs(
    public val id: Output<Int>? = null,
    public val labelId: Output<Int>? = null,
    public val position: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupEpicBoardListArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupEpicBoardListArgs =
        com.pulumi.gitlab.inputs.GroupEpicBoardListArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .labelId(labelId?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupEpicBoardListArgs].
 */
@PulumiTagMarker
public class GroupEpicBoardListArgsBuilder internal constructor() {
    private var id: Output<Int>? = null

    private var labelId: Output<Int>? = null

    private var position: Output<Int>? = null

    /**
     * @param value The ID of the list.
     */
    @JvmName("ulbshrkmymrwcggo")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The ID of the label the list should be scoped to.
     */
    @JvmName("jgtjqtlfejvqorur")
    public suspend fun labelId(`value`: Output<Int>) {
        this.labelId = value
    }

    /**
     * @param value The position of the list within the board. The position for the list is sed on the its position in the `lists` array.
     */
    @JvmName("assqldhejclttwib")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ID of the list.
     */
    @JvmName("gtwpuixhgfrunych")
    public suspend fun id(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ID of the label the list should be scoped to.
     */
    @JvmName("sjpraswhvytsfknt")
    public suspend fun labelId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelId = mapped
    }

    /**
     * @param value The position of the list within the board. The position for the list is sed on the its position in the `lists` array.
     */
    @JvmName("shdjsxqrxoqapdjd")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build(): GroupEpicBoardListArgs = GroupEpicBoardListArgs(
        id = id,
        labelId = labelId,
        position = position,
    )
}
