@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupIssueBoardListArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the list.
 * @property labelId The ID of the label the list should be scoped to.
 * @property position The explicit position of the list within the board, zero based.
 */
public data class GroupIssueBoardListArgs(
    public val id: Output<Int>? = null,
    public val labelId: Output<Int>? = null,
    public val position: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupIssueBoardListArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupIssueBoardListArgs =
        com.pulumi.gitlab.inputs.GroupIssueBoardListArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .labelId(labelId?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupIssueBoardListArgs].
 */
@PulumiTagMarker
public class GroupIssueBoardListArgsBuilder internal constructor() {
    private var id: Output<Int>? = null

    private var labelId: Output<Int>? = null

    private var position: Output<Int>? = null

    /**
     * @param value The ID of the list.
     */
    @JvmName("srumnsjgcmsovnyb")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The ID of the label the list should be scoped to.
     */
    @JvmName("wwauneqfmfveqltr")
    public suspend fun labelId(`value`: Output<Int>) {
        this.labelId = value
    }

    /**
     * @param value The explicit position of the list within the board, zero based.
     */
    @JvmName("ysrfvscbhmwvwhae")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ID of the list.
     */
    @JvmName("yqbnlreibqimgllf")
    public suspend fun id(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ID of the label the list should be scoped to.
     */
    @JvmName("sxscitwuvktucxdu")
    public suspend fun labelId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelId = mapped
    }

    /**
     * @param value The explicit position of the list within the board, zero based.
     */
    @JvmName("kgvnunyknlstdlna")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build(): GroupIssueBoardListArgs = GroupIssueBoardListArgs(
        id = id,
        labelId = labelId,
        position = position,
    )
}
