@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupProtectedEnvironmentApprovalRuleArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessLevel Levels of access allowed to approve a deployment to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
 * @property accessLevelDescription Readable description of level of access.
 * @property groupId The ID of the group allowed to approve a deployment to this protected environment. TThe group must be a sub-group under the given group. Mutually exclusive with `access_level` and `user_id`.
 * @property groupInheritanceType Group inheritance allows access rules to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
 * @property id The unique ID of the Approval Rules object.
 * @property requiredApprovals The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
 * @property userId The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the group with Maintainer role or higher. Mutually exclusive with `access_level` and `group_id`.
 */
public data class GroupProtectedEnvironmentApprovalRuleArgs(
    public val accessLevel: Output<String>? = null,
    public val accessLevelDescription: Output<String>? = null,
    public val groupId: Output<Int>? = null,
    public val groupInheritanceType: Output<Int>? = null,
    public val id: Output<Int>? = null,
    public val requiredApprovals: Output<Int>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupProtectedEnvironmentApprovalRuleArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupProtectedEnvironmentApprovalRuleArgs =
        com.pulumi.gitlab.inputs.GroupProtectedEnvironmentApprovalRuleArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .accessLevelDescription(accessLevelDescription?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupInheritanceType(groupInheritanceType?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .requiredApprovals(requiredApprovals?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupProtectedEnvironmentApprovalRuleArgs].
 */
@PulumiTagMarker
public class GroupProtectedEnvironmentApprovalRuleArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var accessLevelDescription: Output<String>? = null

    private var groupId: Output<Int>? = null

    private var groupInheritanceType: Output<Int>? = null

    private var id: Output<Int>? = null

    private var requiredApprovals: Output<Int>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value Levels of access allowed to approve a deployment to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
     */
    @JvmName("ystomkufbldccbwo")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value Readable description of level of access.
     */
    @JvmName("qxniwyhatkrsjeax")
    public suspend fun accessLevelDescription(`value`: Output<String>) {
        this.accessLevelDescription = value
    }

    /**
     * @param value The ID of the group allowed to approve a deployment to this protected environment. TThe group must be a sub-group under the given group. Mutually exclusive with `access_level` and `user_id`.
     */
    @JvmName("mhyoyvcgngwxnuev")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value Group inheritance allows access rules to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
     */
    @JvmName("pejdbadglcawrbri")
    public suspend fun groupInheritanceType(`value`: Output<Int>) {
        this.groupInheritanceType = value
    }

    /**
     * @param value The unique ID of the Approval Rules object.
     */
    @JvmName("frvggyvwavglcxvv")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
     */
    @JvmName("dimqlgrnidptvtkt")
    public suspend fun requiredApprovals(`value`: Output<Int>) {
        this.requiredApprovals = value
    }

    /**
     * @param value The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the group with Maintainer role or higher. Mutually exclusive with `access_level` and `group_id`.
     */
    @JvmName("jpxnyrffmyhxpivm")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value Levels of access allowed to approve a deployment to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
     */
    @JvmName("iadeewxbkaavxqcj")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value Readable description of level of access.
     */
    @JvmName("eoxknloifxjwijpb")
    public suspend fun accessLevelDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevelDescription = mapped
    }

    /**
     * @param value The ID of the group allowed to approve a deployment to this protected environment. TThe group must be a sub-group under the given group. Mutually exclusive with `access_level` and `user_id`.
     */
    @JvmName("rhaogtuomafnffcp")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Group inheritance allows access rules to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
     */
    @JvmName("lfmdbcxheottaovl")
    public suspend fun groupInheritanceType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupInheritanceType = mapped
    }

    /**
     * @param value The unique ID of the Approval Rules object.
     */
    @JvmName("qicmljgnidryggog")
    public suspend fun id(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
     */
    @JvmName("rkxwbdmggsejcixg")
    public suspend fun requiredApprovals(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredApprovals = mapped
    }

    /**
     * @param value The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the group with Maintainer role or higher. Mutually exclusive with `access_level` and `group_id`.
     */
    @JvmName("yenoteyouuranxgs")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): GroupProtectedEnvironmentApprovalRuleArgs =
        GroupProtectedEnvironmentApprovalRuleArgs(
            accessLevel = accessLevel,
            accessLevelDescription = accessLevelDescription,
            groupId = groupId,
            groupInheritanceType = groupInheritanceType,
            id = id,
            requiredApprovals = requiredApprovals,
            userId = userId,
        )
}
